<?php 
include 'db.php'; 
session_start();
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 

// جلب الباقات من قاعدة البيانات
 $packages_query = $conn->query("SELECT * FROM packages");
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - الباقات</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --card-bg: #1e1e1e;
            --text-muted: #aaa;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            padding-bottom: 80px; /* مساحة للشريط السفلي */
        }

        /* الشريط العلوي */
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 15px 20px;
            background: var(--card-bg);
            border-bottom: 1px solid rgba(255, 215, 0, 0.1);
            position: sticky;
            top: 0;
            z-index: 100;
        }

        .top-bar .brand {
            font-weight: bold;
            font-size: 1.2rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .user-balance-display {
            font-size: 0.9rem;
            color: var(--primary-color);
            font-weight: bold;
        }

        /* حاوية الباقات */
        .packages-container {
            padding: 15px;
        }

        .section-title {
            margin-bottom: 15px;
            color: white;
            font-size: 1.1rem;
            border-right: 4px solid var(--secondary-color);
            padding-right: 10px;
        }

        /* تصميم بطاقة الباقة */
        .package-card {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 15px;
            margin-bottom: 20px;
            display: flex; /* يجعل العناصر بجانب بعضها */
            align-items: center;
            justify-content: space-between;
            border-bottom: 2px solid rgba(255, 255, 255, 0.05);
            transition: transform 0.2s;
        }

        .package-card:active {
            transform: scale(0.98);
        }

        /* الجهة اليمنى: المعلومات والزر */
        .pkg-info {
            flex: 1; /* يأخذ المساحة المتاحة */
            padding-left: 15px; /* مسافة بين الصورة والمعلومات */
            display: flex;
            flex-direction: column;
            justify-content: center;
        }

        .pkg-name {
            font-size: 1.1rem;
            font-weight: bold;
            margin-bottom: 5px;
            color: white;
        }

        .pkg-details {
            font-size: 0.85rem;
            color: var(--text-muted);
            margin-bottom: 12px;
            display: flex;
            gap: 8px;
            flex-wrap: wrap; /* للسماح بانتشار العناصر في سطر جديد إذا ضاقت الشاشة */
        }

        .pkg-details span {
            background: rgba(255, 255, 255, 0.1);
            padding: 3px 8px;
            border-radius: 6px;
            display: flex;
            align-items: center;
            gap: 4px;
        }

        .price-tag {
            color: var(--primary-color);
            font-weight: bold;
            font-size: 0.9rem;
        }

        .days-tag {
            color: #ff9800; /* لون برتقالي للأيام */
            font-weight: bold;
        }

        /* زر الشراء */
        .buy-btn {
            background: linear-gradient(45deg, var(--secondary-color), #ff6b6b);
            color: white;
            border: none;
            padding: 8px 20px;
            border-radius: 20px;
            font-family: 'Tajawal', sans-serif;
            font-weight: bold;
            cursor: pointer;
            width: 100%;
            font-size: 0.9rem;
            box-shadow: 0 4px 10px rgba(255, 69, 0, 0.3);
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 5px;
        }

        .buy-btn:disabled {
            background: #444;
            color: #888;
            cursor: not-allowed;
            box-shadow: none;
        }

        /* الجهة اليسرى: الصورة */
        .pkg-img-box {
            width: 80px;
            height: 80px;
            flex-shrink: 0; /* يمنع الصورة من الانكماش */
            position: relative;
        }

        .pkg-img-box img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 12px;
            border: 1px solid rgba(255, 215, 0, 0.2);
        }

        /* الشريط السفلي */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            width: 100%;
            background: var(--card-bg);
            display: flex;
            justify-content: space-around;
            padding: 10px 0;
            border-top: 1px solid rgba(255, 215, 0, 0.1);
            z-index: 1000;
        }

        .nav-item {
            text-decoration: none;
            color: #888;
            display: flex;
            flex-direction: column;
            align-items: center;
            font-size: 0.7rem;
        }

        .nav-item.active {
            color: var(--primary-color);
        }

        .nav-item i {
            font-size: 1.3rem;
            margin-bottom: 4px;
        }
    </style>
</head>
<body>

    <!-- الشريط العلوي -->
    <div class="top-bar">
        <div class="brand">Chicken Charge</div>
        <div class="user-balance-display">
            <i class="fas fa-wallet"></i> $<?= number_format($u['balance'], 2) ?>
        </div>
    </div>

    <!-- محتوى الباقات -->
    <div class="packages-container">
        <div class="section-title">الباقات المتاحة</div>

        <?php 
        if($packages_query->num_rows > 0):
            while($p = $packages_query->fetch_assoc()):
                // التحقق مما إذا كان الرصيد يكفي
                $can_buy = ($u['balance'] >= $p['price']);
                
                // جلب الصورة من الأدمن، ووضع صورة افتراضية إذا كانت فارغة فقط
                $imgSrc = (!empty($p['image'])) ? $p['image'] : 'https://via.placeholder.com/80?text=PKG';
        ?>
        
        <div class="package-card">
            <!-- اليسار: الصورة (من لوحة التحكم) -->
            <div class="pkg-img-box">
                <img src="<?= $imgSrc ?>" alt="<?= $p['name'] ?>">
            </div>

            <!-- اليمين: المعلومات والزر -->
            <div class="pkg-info">
                <div class="pkg-name"><?= $p['name'] ?></div>
                
                <div class="pkg-details">
                    <span class="price-tag">$<?= number_format($p['price'], 2) ?></span>
                    <span><i class="fas fa-chart-line"></i> <?= $p['daily_profit'] ?>/يوم</span>
                    <!-- إضافة عدد الأيام -->
                    <span class="days-tag"><i class="fas fa-calendar-check"></i> <?= $p['days'] ?> يوم</span>
                </div>

                <form method="post" action="buy.php">
                    <input type="hidden" name="pid" value="<?= $p['id'] ?>">
                    <?php if($can_buy): ?>
                        <button type="submit" class="buy-btn">
                            شراء الآن <i class="fas fa-arrow-left"></i>
                        </button>
                    <?php else: ?>
                        <button type="button" class="buy-btn" disabled>
                            رصيد غير كافٍ
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        </div>

        <?php 
            endwhile; 
        else:
        ?>
            <div style="text-align:center; padding: 20px; color: #666;">
                لا توجد باقات متاحة حالياً.
            </div>
        <?php endif; ?>

    </div>

    <!-- الشريط السفلي -->
    <nav class="bottom-nav">
        <a href="home.php" class="nav-item">
            <i class="fas fa-home"></i>
            <span>البيت</span>
        </a>
        <a href="tasks.php" class="nav-item">
            <i class="fas fa-tasks"></i>
            <span>المهام</span>
        </a>
        <a href="referral.php" class="nav-item">
            <i class="fas fa-users"></i>
            <span>الأصدقاء</span>
        </a>
        <!-- تفعيل زر الباقات -->
        <a href="packages.php" class="nav-item active">
            <i class="fas fa-box-open"></i>
            <span>الباقات</span>
        </a>
        <a href="profile.php" class="nav-item">
            <i class="fas fa-user-circle"></i>
            <span>ملفي</span>
        </a>
    </nav>

</body>
</html>