<?php 
include 'db.php'; 
session_start();
// تأكد من أن المستخدم مدير قبل الدخول
if(!isset($_SESSION['user'])){ header("Location: login.php"); exit(); }
 $u = $_SESSION['user']; 
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Chicken Charge - لوحة التحكم</title>
    <link href="https://fonts.googleapis.com/css2?family=Tajawal:wght@400;500;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    <style>
        :root {
            --primary-color: #FFD700; 
            --secondary-color: #FF4500;
            --bg-dark: #121212;
            --sidebar-bg: #1a1a1a;
            --card-bg: #252525;
            --text-muted: #aaa;
        }

        * {
            box-sizing: border-box;
        }

        body {
            font-family: 'Tajawal', sans-serif;
            background-color: var(--bg-dark);
            color: white;
            margin: 0;
            display: flex;
            min-height: 100vh;
        }

        /* القائمة الجانبية (Sidebar) */
        .sidebar {
            width: 260px;
            background-color: var(--sidebar-bg);
            border-left: 1px solid #333;
            display: flex;
            flex-direction: column;
            position: fixed;
            height: 100%;
            right: 0;
            top: 0;
            z-index: 100;
        }

        .sidebar-header {
            padding: 30px 20px;
            text-align: center;
            border-bottom: 1px solid rgba(255,255,255,0.05);
        }

        .brand-logo {
            font-weight: bold;
            font-size: 1.4rem;
            background: linear-gradient(45deg, var(--primary-color), var(--secondary-color));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .nav-links {
            flex: 1;
            padding: 20px 0;
            list-style: none;
            margin: 0;
        }

        .nav-links li a {
            display: flex;
            align-items: center;
            padding: 15px 25px;
            color: var(--text-muted);
            text-decoration: none;
            transition: 0.3s;
            border-right: 3px solid transparent;
            font-size: 1rem;
        }

        .nav-links li a:hover, .nav-links li a.active {
            background: rgba(255, 215, 0, 0.05);
            color: var(--primary-color);
            border-right-color: var(--primary-color);
        }

        .nav-links li a i {
            margin-left: 15px;
            width: 20px;
            text-align: center;
        }

        .sidebar-footer {
            padding: 20px;
            border-top: 1px solid rgba(255,255,255,0.05);
        }

        /* المحتوى الرئيسي */
        .main-content {
            margin-right: 260px; /* مسافة للسايدبار */
            flex: 1;
            padding: 30px;
            width: calc(100% - 260px);
        }

        .top-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 40px;
        }

        .page-title {
            font-size: 1.8rem;
            font-weight: bold;
        }

        .admin-badge {
            background: rgba(255, 215, 0, 0.15);
            color: var(--primary-color);
            padding: 5px 15px;
            border-radius: 20px;
            font-size: 0.8rem;
            font-weight: bold;
            display: inline-flex;
            align-items: center;
            gap: 5px;
        }

        /* شبكة بطاقات الوصول السريع */
        .dashboard-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 25px;
        }

        .dash-card {
            background: var(--card-bg);
            border-radius: 15px;
            padding: 30px;
            text-decoration: none;
            color: white;
            border: 1px solid rgba(255,255,255,0.05);
            transition: 0.3s;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            height: 180px;
            position: relative;
            overflow: hidden;
        }

        .dash-card:hover {
            transform: translateY(-5px);
            border-color: var(--primary-color);
            box-shadow: 0 10px 20px rgba(0,0,0,0.3);
        }

        .card-icon {
            font-size: 2.5rem;
            margin-bottom: 20px;
            opacity: 0.8;
        }

        .card-title {
            font-size: 1.2rem;
            font-weight: bold;
            margin-bottom: 5px;
        }

        .card-desc {
            font-size: 0.85rem;
            color: var(--text-muted);
        }

        /* ألوان خاصة لكل كرت */
        .dash-card.packages .card-icon { color: #4CAF50; }
        .dash-card.actions .card-icon { color: #2196F3; }
        .dash-card.settings .card-icon { color: #FF9800; }

        /* استجابة للشاشات الصغيرة */
        @media (max-width: 768px) {
            .sidebar {
                width: 70px; /* تصغير القائمة */
            }
            .sidebar-header h1, .nav-links span, .sidebar-footer span {
                display: none; /* إخفاء النصوص */
            }
            .nav-links li a {
                justify-content: center;
                padding: 15px 0;
            }
            .nav-links li a i {
                margin-left: 0;
                font-size: 1.2rem;
            }
            .main-content {
                margin-right: 70px;
                width: calc(100% - 70px);
                padding: 15px;
            }
            .dashboard-grid {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>

    <!-- القائمة الجانبية -->
    <aside class="sidebar">
        <div class="sidebar-header">
            <div class="brand-logo">Admin Panel</div>
        </div>

        <ul class="nav-links">
            <li>
                <a href="admin.php" class="active">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>الرئيسية</span>
                </a>
            </li>
            <li>
                <a href="admin_packages.php">
                    <i class="fas fa-boxes"></i>
                    <span>إدارة الباقات</span>
                </a>
            </li>
            <li>
                <a href="admin_actions.php">
                    <i class="fas fa-wallet"></i>
                    <span>الطلبات (إيداع/سحب)</span>
                </a>
            </li>
            <li>
                <a href="admin_settings.php">
                    <i class="fas fa-cogs"></i>
                    <span>الإعدادات العامة</span>
                </a>
            </li>
        </ul>

        <div class="sidebar-footer">
            <a href="logout.php" style="color: #ff4d4d; text-decoration: none; display: flex; align-items: center;">
                <i class="fas fa-sign-out-alt"></i>
                <span style="margin-right: 10px;">تسجيل خروج</span>
            </a>
        </div>
    </aside>

    <!-- المحتوى الرئيسي -->
    <main class="main-content">
        <div class="top-header">
            <h2 class="page-title">لوحة التحكم</h2>
            <div class="admin-badge">
                <i class="fas fa-user-shield"></i>
                <?= $u['username'] ?>
            </div>
        </div>

        <div class="dashboard-grid">
            <!-- كرت الباقات -->
            <a href="admin_packages.php" class="dash-card packages">
                <div>
                    <i class="fas fa-box-open card-icon"></i>
                    <h3 class="card-title">الباقات</h3>
                    <p class="card-desc">إضافة، تعديل، حذف باقات الربح.</p>
                </div>
            </a>

            <!-- كرت الإيداع والسحب -->
            <a href="admin_actions.php" class="dash-card actions">
                <div>
                    <i class="fas fa-money-bill-wave card-icon"></i>
                    <h3 class="card-title">العمليات المالية</h3>
                    <p class="card-desc">قبول طلبات الإيداع وصرف الأرباح.</p>
                </div>
            </a>

            <!-- كرت الإعدادات -->
            <a href="admin_settings.php" class="dash-card settings">
                <div>
                    <i class="fas fa-sliders-h card-icon"></i>
                    <h3 class="card-title">الإعدادات</h3>
                    <p class="card-desc">تعديل عناوين المحافظ والنظام.</p>
                </div>
            </a>
        </div>

        <!-- (اختياري) قسم للإحصائيات السريعة -->
        <div style="margin-top: 40px;">
            <h3 style="margin-bottom: 20px; border-bottom: 1px solid #333; padding-bottom: 10px;">حالة النظام</h3>
            <div style="display: flex; gap: 20px; flex-wrap: wrap;">
                <div style="background: #1a1a1a; padding: 15px 25px; border-radius: 10px; border-right: 3px solid #00ff00;">
                    <span style="color: #888; font-size: 0.9rem;">الحالة:</span>
                    <span style="color: #00ff00; margin-right: 10px;">نشط <i class="fas fa-circle" style="font-size: 8px;"></i></span>
                </div>
                <div style="background: #1a1a1a; padding: 15px 25px; border-radius: 10px; border-right: 3px solid var(--primary-color);">
                    <span style="color: #888; font-size: 0.9rem;">الإصدار:</span>
                    <span style="color: white; margin-right: 10px;">v1.0</span>
                </div>
            </div>
        </div>

    </main>

</body>
</html>